/**
 * tab manager
 * @author sunnyjiang
 * @version 1.1
 */

var tabManager = {};

tabManager.iconMap = {};
tabManager.loadStatus = [];

/**
 * init tabs
 */
tabManager.init = function() {
	tabManager.addFirstTab(); // add frist tab
	
	$("#tabset").buildMbTabset({
		sortable: true
	});	
};

/**
 * init tabs from data
 */ 
tabManager.initTabFromData = function() {	
	for(var i = 0; i < tabsData.length; i++) {
		var id = this.getIdFromIndex(i + 1);
		var tabData = tabsData[i];
		var title = utils.encodeHtml(tabData.title);
		var url = utils.encodeHtml(tabData.url);
		var icon = tabData.icon;
		
		var tabset = $('#tabset');
		tabset.buildTab(tabset, id, url, title, icon);
	}
};

/**
 * init first tab
 */
tabManager.addFirstTab = function() {
	var tabset = $('#tabset');
	var tabId = 'tab_0';
	
	tabset.buildTab(tabset, tabManager.getIdFromIndex(0), FIRST_SITE_URL); // ' '为第一个自建tab用于鉴别的url, 在listener里核对
};

/**
 * open a tab of link
 */
tabManager.addTab = function(url, title, icon) {
	if(tabManager.getCount() >= MAX_TAB_COUNT) {
		return;
	}
	
	// 如果传进来url，以传进来的为准
	if(url) {
		url = utils.encodeHtml(url);
		title = utils.encodeHtml(title);
	} else { // 默认qb:home
		url = DEFAULT_SITE_URL;
		title = DEFAULT_SITE_TITLE;
	}

	if(browser.isPage()) { // 页面环境下进行添加tab测试
		var tabId = tabManager.newTab(url, title, icon); // 界面上创建新tab
		tabManager.activeTab(tabManager.getTabFromId(tabId));
	} else {
		browser.tabs.create(url, 0); // 通知浏览器创建页面, 0标志皮肤
	}
};

/**
 * 仅添加一个tab，不通知浏览器
 */
tabManager.newTab = function(url, title, icon, engine) {
	var tabId = $('#tabset').addMbTab(url, title, icon, engine);
	layout.adjustTabBar();
	
	return tabId;
};

/**
 * 在指定位置添加一个tab，不通知浏览器
 */
tabManager.newTab2Index = function(url, title, icon, engine, index) {
	var tabId = $('#tabset').addMbTab(url, title, icon, engine, index);
	layout.adjustTabBar();
	
	return tabId;
};

/**
 * active a tab
 * @param index of tab
 */
tabManager.activeTab = function(tab) {
	// 激活的机制为点击所需的标签
	tab.mousedown();
	tab.mouseup(); // 焦点切换必须
};

tabManager.switchTab = function(tab) {
	// 激活的机制为点击所需的标签
	tab.data('switch', 1);
	tab.mousedown();
	tab.mouseup(); // 焦点切换必须
	tab.data('switch', 0);
};

/**
 * close a tab
 */ 
tabManager.removeTab = function(element, isNotifyBrowser, selectId) {

	var tabsCount = this.getCount();
	
	var closeTab = element instanceof jQuery ? element : $(element);
		
	// 如果传进来是a，是标签本身，如果是div，则是close button
	while(!closeTab.is('.mbTab')) {
		closeTab = closeTab.parent();
	}
	
	if(tabsCount == 1 && tabManager.getUrl(closeTab) == DEFAULT_SITE_URL) { // 最后一个默认网址不关闭
		return;
	}

	var tabId = closeTab.attr('id');

	var closeTabIndex = tabManager.getIndexFromId(tabId);
		
	if(selectId) { // 如果有tab selectid，激活该selectid对应的tab
		var tab = this.getTabFromPageId(selectId);
		tabManager.activeTab(tab);
	}
	
	if(!isNotifyBrowser) { // 拖拽出新窗口时，不remove page
		browser.tabs.remove(closeTabIndex);	
	}
	
	// 不是最后一个标签关闭时，鼠标out tabset时才会计算和改变tab大小，目的是让关闭按钮一直在同一位置
	// 浏览器通知关闭时也计算和改变tab大小，有可能是通过浏览器快捷键进来
	if(tabManager.isLastTab(closeTabIndex) || isNotifyBrowser) {
		setTimeout("layout.adjustTabBar()", 150);
	} else {
		$('#tab-inner').one("mouseleave", function() {
			setTimeout("layout.adjustTabBar()", 150);
		});
	}

	tipManager.hideTooltip();
	
	closeTab.remove(); // remove tab from dom

	if(tabsCount == 1) { // 如果tab数量为1，关闭后打开默认页面
		tabManager.addTab(DEFAULT_SITE_URL);
	}
};

/**
 * close a tab
 */ 
tabManager.removeTabById = function(id) {
	tabManager.removeTab($('#' + id).get(0));
};

/**
 * 判断是否是最后一个标签，判断方法是遍历，可以优化成排序
 */
tabManager.getMaxTabIndex = function(index) {
	var tabs = this.getTabs();
	var maxIndex = -1;
	tabs.each( function() {
			var currentIndex = tabManager.getIndexFromId($(this).attr('id'));
			if(currentIndex > maxIndex)
				maxIndex = currentIndex;
		}
	);
	return maxIndex;
};

/**
 * 判断是否是最后一个标签
 */
tabManager.isLastTab = function(index) {
//	return !tabManager.getNextTab(index).attr('id');
	var a = tabManager.getLastTab();
	var b = tabManager.getIndexFromTab(a);
	return index == tabManager.getIndexFromTab(tabManager.getLastTab());
};

/**
 * 判断是否是第一个
 */
tabManager.isFirstTab = function(index) {
	return index == tabManager.getIndexFromTab(tabManager.getFirstTab());
};

tabManager.isActive = function(tab) {
	return tab.is('.sel');
};

/**
 * 获得第一个tab
 */
tabManager.getFirstTab = function() {
	var tab = $('#tabset > div:first-child');
	
	// 有可能是sortable helper
	if(!tab.attr('id')) {
		tab = tab.next();
	}
	return tab;
};

/**
 * 获得最后一个tab
 */
tabManager.getLastTab = function() {
	var tab = $('#tabset > div:last-child');
	
	// 有可能是sortable helper
	if(!tab.attr('id')) {
		tab = tab.prev();
	}
	return tab;
};

/**
 * get previous tab
 */
tabManager.getPreviousTab = function(index) {
	var tab = tabManager.getTab(index).prev();
	
	// 有可能是sortable helper
	if(!tab.attr('id')) {
		tab = tab.prev();
	}
	return tab;	
};

/**
 * get next tab
 */
tabManager.getNextTab = function(index) {
	var tab = tabManager.getTab(index).next();
	// 有可能是sortable helper
	
	if(!tab.attr('id')) {
		tab = tab.next();
	}
	return tab;
};

/**
 * get id from index
 */
tabManager.getIdFromIndex = function(index) {
	return 'tab_' + index;
};

/**
 * get index from id
 */
tabManager.getIndexFromId = function(id) {
	if(id) {
		return parseInt(id.split('_')[1]);
	}
};

/**
 * get index from tab
 */
tabManager.getIndexFromTab = function(tab) {
	return tabManager.getIndexFromId(tab.attr('id'));
};

/**
 * get a tab
 */ 
tabManager.getTab = function(index) {
	return $('#tab_' + index);
};

/**
 * get tab from Id
 */ 
tabManager.getTabFromId = function(tabId) {
	return $('#' + tabId);
};

/**
 * get tab count
 */
tabManager.getCount = function() {
	return this.getTabs().length;
};

/**
 * get tabs
 */
tabManager.getTabs = function() {
	return $('#tabset').children();
};

/**
 * charge tab is current tab or not
 */
tabManager.isCurrentTab = function(tab) {
	return tab.attr('id') == tabManager.getCurrentTabId();
};

/**
 * get index of current tab 
 */
tabManager.getCurrentTabIndex = function() {
	var tabId = $('#tabset').children('.sel').attr('id');
	return this.getIndexFromId(tabId);
}; 

/**
 * get id of current tab 
 */
tabManager.getCurrentTabId = function() {
	return $('#tabset').children('.sel').attr('id');
};

/**
 * get current tab
 */
tabManager.getCurrentTab = function() {
	return $($('#tabset').children('.sel')[0]);
};


/**
 * set title
 */
tabManager.setTitle = function(tab, title) {
//	var tab = tabManager.getTab(index);
	$('span .title', tab).html(title);
};

/**
 * get title
 */
tabManager.getTitle = function(tab) {
	return $('span .title', tab).html();
};

/**
 * close all tabs
 */ 
tabManager.closeAllTabs = function() {
	var tabs = tabManager.getTabs();
	for(var i = 1; i < tabs.length; i++)
		tabManager.removeTab(tabs[i]);
};

/**
 * close selected tab, for context menu
 */
tabManager.closeSelectedTab = function() {
	tabManager.removeTabById(menu.getSourceId());
};

/**
 * close other tabs but current
 */
tabManager.closeOtherTabs = function() {
	var tabs = tabManager.getTabs();
	
	for(var i = 0; i < tabs.length; i++) {
		if($(tabs[i]).attr('id') != menu.getSourceId()) // compare current id to each id
			tabManager.removeTab(tabs[i]);
	}
	
	// 避免和removeTab的mouseout方法冲突
	layout.adjustTabBar();
	$('#tab-wrapper').unbind('mouseout');
};

/**
 * get width of tab
 */
tabManager.getFirstTabWidth = function() {
	return $('#tab_0').width();
};

tabManager.getMarginLeft = function() {
	return utils.fromPx2Int($(tabManager.getTabs()[1]).css('margin-left')); // 第一个为0，取后面一个
};

/**
 * set or get pageid of tab
 */
tabManager.setPageId = function(tabId, pageId) {
	$('#' + tabId).attr('pageid', pageId);
};

tabManager.getTabFromPageId = function(pageId) {
	return $('#tabset div.tab[pageid="' + pageId + '"]');
};

tabManager.getPageIdFromTab = function(tab) {
	//var ret="0";
	try{
		ret = tab.attr('pageid');
	}catch(err){
		ret="0";
	}	
	return parseInt(ret);
};

tabManager.getPageIdFromTabForBlank = function(tab) {
	//var ret="0";
	try{
		ret = ($('#' + tab).attr('pageid'));
	}catch(err){
		ret="0";
	}
	return parseInt(ret);
};
tabManager.getPageIdFromTabIndex = function(index) {
	return parseInt($('#' + tabManager.getIdFromIndex(index)).attr('pageid'));
};

tabManager.getPageIdFromTabId = function(tabId) {
	return parseInt($('#' + tabId).attr('pageid'));
};

/**
 * set icon of tab
 */
tabManager.setIcon = function(tab, url) {
	$('span img', tab).removeClass('loading-animate');
	$('span img', tab).attr('src', url);
	clearInterval(tabManager.loadtimer);
};

// 设置图标为默认图标
tabManager.setDefualtIcon = function(tab) {
	var tabId = tab.attr('id');
	
	// 只有在loading时才会设置图标为默认图标, 已经加载favicon时不替换为默认图标
	if($('span img', tab).is('.loading-animate')) {
		tabManager.setIcon(tab, TAB_DEFAULT_ICON);
	}
};
// 设置图标
tabManager.loadtimer = -1;
tabManager.setLoadingIcon = function(tab) {
	$('span img', tab).attr('src', TAB_LOADING_ICON).addClass('loading-animate');
	var aim = $('span img', tab);
	aim.data('cnt',0);
	if (-1 != tabManager.loadtimer){
		clearInterval(tabManager.loadtimer);
	}
	tabManager.loadtimer = setInterval(function(){
		var imgpath = "images\\tab\\loading\\";	
		var cnt = aim.data('cnt');
		cnt%=11;
		imgpath+=((cnt + 1)+".png");
//		alert(imgpath);
		aim.attr('src',imgpath);
		cnt++;
		aim.data('cnt',cnt);
	},100);
};

/**
 * 滚轮切换tab
 */
tabManager.scrollTabs = function(e) {
	var direct = 0; 
	e = e || window.event; 
	
	if(e.wheelDelta < 0){ // 向下滚轮，向右移动tab
		var currentTabIndex = tabManager.getCurrentTabIndex();
		
		// 已经是最后一个tab时选中第一个    		
		var tab = tabManager.isLastTab(currentTabIndex) ? tabManager.getFirstTab() : tabManager.getNextTab(currentTabIndex); 
	} else { // 向上滚轮，向左移动tab
		var currentTabIndex = tabManager.getCurrentTabIndex();

		// 已经是第一个tab时选中最后一个
		var tab = tabManager.isFirstTab(currentTabIndex) ? tabManager.getLastTab() : tabManager.getPreviousTab(currentTabIndex);
	}
	
	tabManager.activeTab(tab);
	browser.extension.builtin.statistics.increase(STATIS_CMD_SWITCH_TAB_BY_WHEEL);	//滚轮切换标签次数上报
};

tabManager.setUrl = function(tab, url) {
	tab.data('url', url);
};

tabManager.getUrl = function(tab) {
	return tab.data('url');
};
